﻿using System;
using System.Reflection;
using System.Threading;
using VBECS.Services.Common.Timing;
using gov.va.med.vbecs.Common.AppServices;
using gov.va.med.vbecs.Common.Log;
using gov.va.med.vbecs.DAL.HL7AL;
using IServer = gov.va.med.vbecs.Common.IServer;

namespace gov.va.med.VBECS.HL7DispatcherServer
{
    internal class Server : IServer
    {
        /// <summary>
        /// Implements Simple Example for timing job
        /// </summary>

        public event EventHandler<ThreadExceptionEventArgs> FatalErrorOccured;

        // Inner server
        private global::VBECS.Services.Common.Timing.IServer _server;
        // Logger
        private readonly ILogger _logger =
            LogManager.Instance().LoggerLocator.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);
        // Events Logger
        private readonly ILogger _eventsLogger =
            LogManager.Instance().LoggerLocator.GetLogger("SystemEvents");

        public void Start()
        {
            if (_server != null) return; // The server is already started

            // Read timeout from configuration
            var timeOut = (int)GlobalContext.Instance().AppSettingsReader.GetValue("TimeOut", typeof(int));
            // TODO: assign server using Spring.NET or Factory
            _server = new SynchronousServer(timeOut);
            _server.TimeoutElapsed += ServerOnTimeoutElapsed;
            _server.FatalErrorOccured += delegate(object sender, ThreadExceptionEventArgs args)
            {
                // Report to caller is subscribed
                if (FatalErrorOccured != null)
                    FatalErrorOccured(sender, args);
            };

            _server.Start();
            _logger.Debug("Server started");
            _eventsLogger.Debug("Server started");
        }

        private void ServerOnTimeoutElapsed(object sender, EventArgs eventArgs)
        {
            try
            {
                //TODO: Rewrite the following method to use VBECS.Communication.Client functionality
                new VbecsHL7ClientMonitor.HL7ClientMonitor().GetAndSendHL7Message(null);
            }
            catch (Exception e)
            {
                //Log exception but continue to print any other reports in queue.
                _logger.Error(e.Message);
                _eventsLogger.Error(e.Message);
            }
        }

        public void Stop()
        {
            if (_server == null) return; // The server is not started
            _server.Stop();
            _server = null;
            _logger.Debug("A server stopped");
        }
    }
}
